%% Spectogram
% Martin H. Trauth 10 June 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all

%%
% We then define the noise level, i.e. the standard deviation of the
% Gaussian noise Ns, the sampling frequency Fs and create a time vector t.
Ns = 5;
Fs = 2;
t = 1/Fs : 1/Fs : 500; t = t';

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and without noise. The intermediate
% cycle occurs in the second half the the time series only.
rng(0)
n = length(t);
x =  2*sin(2*pi*t/50) + ...
    0.5*sin(2*pi*t/5);
x(n/2+1:end,1) = x(n/2+1:end,1) + ...
    sin(2*pi*t(n/2+1:end,1)/15);

figure('Position',[100 800 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 500],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,x,...
    'LineWidth',1)

%%
% We can use the periodogram function of MATLAB to calculate a Fourier
% spectrum of the signal, displayed as the power spectral density against
% the frequency f and the period T.
[Pxx,f] = periodogram(x,[],length(t),Fs);

figure('Position',[100 500 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')

%%
% We can use the spectrogram function of MATLAB to calculate an
% evoluationary Fourier spectrum of the signal, displayed as a pseudocolor
% plot of the power spectral density (colors), against the frequency f and
% the time t.
[sp,fp,tp] = spectrogram(x,128,100,512,Fs);

figure('Position',[100 200 800 400],...
    'Color',[1 1 1])
axes('YLim',[0 0.3],...
    'XGrid','On',...
    'YGrid','On'), hold on
pcolor(tp,fp,(abs(sp))), shading flat
xlabel('Time')
ylabel('Frequency')
set(gcf,'Colormap',jet)

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and additive Gaussian noise Ns. The
% intermediate cycle occurs in the second half the the time series only.
rng(0)
n = length(t);
x =  2*sin(2*pi*t/50) + ...
    0.5*sin(2*pi*t/5);
x(n/2+1:end,1) = x(n/2+1:end,1) + ...
    sin(2*pi*t(n/2+1:end,1)/15);
x = x + randn(size(x));

figure('Position',[100 800 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 500],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,x,...
    'LineWidth',1)

%%
% We can use the periodogram function of MATLAB to calculate a Fourier
% spectrum of the signal, displayed as the power spectral density against
% the frequency f and the period T.
[Pxx,f] = periodogram(x,[],length(t),Fs);

figure('Position',[100 500 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')

%%
% We can use the spectrogram function of MATLAB to calculate an
% evoluationary Fourier spectrum of the signal, displayed as a pseudocolor
% plot of the power spectral density (colors), against the frequency f and
% the time t.
[s,f,t] = spectrogram(x,128,100,512,Fs);

figure('Position',[100 200 800 400],...
    'Color',[1 1 1])
axes('YLim',[0 0.3],...
    'XGrid','On',...
    'YGrid','On'), hold on
pcolor(t,f,(abs(s))), shading flat
xlabel('Time')
ylabel('Frequency')
set(gcf,'Colormap',jet)






